'
'  This program uses interrupt 10 to analyze VESA XGA video systems.  It
' will first tell you whether or not your video system is a VESA XGA.  If
' so, it will then tell you your VESA version number and then list all
' video modes that your system supports (and that the video board was
' programmed to be aware of) in the file MODES.LST.  This file will also
' show various characteristics of each mode, including whether the
' particular mode is supported in hardware or bios.
'
'  The XGA board is queried by inspecting various outputs from it bit by
' bit.  Tell QB that a function exists to get these bits and then set up
' register variables for INTERRUPTX routine.
'
DECLARE FUNCTION BIN$(N AS LONG)
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,A(1 TO 64) AS LONG,DUMMY AS LONG
DIM BYTE AS LONG,HR AS INTEGER,VR AS INTEGER,HS AS INTEGER,VS AS INTEGER
'
'  VESA data will be stored in array A (256 bytes).  The PEEK function is
' used to get data out of this array.
'
'  Before looking for VESA support, find out if XGA is supported at all.
' If so, get slot numbers of XGA boards.
'
INREGS.AX=&H1F00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
IF OUTREGS.AX<>&H1F00 THEN
DIM SLOT(1 TO 8) AS INTEGER
SM=VARSEG(A(1)) : OS=VARPTR(A(1))
'
'  Get XGA information.
'
INREGS.AX=&H1F01
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
DEF SEG=SM
'
'  OFFB is the offset into A for the current XGA under analysis and OFFNB
' is the OFFSET for the next XGA.
'
OFFB=OS
'
'  XGA$ counts the number of XGA cards indicated by the calls to function
' 1F.  (This will later be compared to the output from function 4E.)
'
FOR I=1 TO 8
XGA$=LTRIM$(RTRIM$(STR$(I)))
OFFNB=PEEK(OFFB)+256*PEEK(OFFB+1)
SLOT(I)=PEEK(OFFB+2)
IF OFFNB<>0 THEN
OFFB=OFFB+OFFNB
ELSE
EXIT FOR
END IF
NEXT I
'
'  Up to 1000 INTEGER video modes are stored in the array MD.
'
DIM MD(1 TO 1000) AS INTEGER,PLANES AS INTEGER,ENVOS AS INTEGER,PAGES AS INTEGER
'
'  Function 4E / subfunction 00 is used to get basic information about
' VESA support.  Define inputs for this function and call interrupt 10.
' (ES:DI is a pointer to array A, just as with the call to function 1F.)
'
INREGS.AX=&H4E00
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  Basic is still pointed to A.  First four bytes spell "VESA" if system
' is VESA-aware.  Either tell user that VESA XGA is present and analyze
' it, or that VESA XGA is not present.
'
T$=CHR$(PEEK(OS))+CHR$(PEEK(OS+1))+CHR$(PEEK(OS+2))+CHR$(PEEK(OS+3))
CLS
IF T$="VESA" THEN
'
'  Find out where name of program being run is stored in computer's RAM
' and then find disk it was run from (so output file can be put there
' if program is not being run from current disk).  (Okay, I'll break down
' and explain what I'm doing here--and I'm quite sure there's an easier
' way to do it, I just don't know what it is.  (This is a much larger
' diversion from the point of this program than I would have liked to have
' made.)  Interrupt 21 / function 62 returns the program segment prefix
' (PSP), i.e., the memory segment at which THIS program is running.  At an
' offset of 2C hex bytes into this segment is a 2-byte integer giving the
' segment of this program's copy of the DOS environment block.  (I'm
' assuming the corresponding offset is always zero.)  Once I have the
' address of the environment, I redirect the "binary pointer" defined with
' DEF SEG there.  At some point into this memory segment, there is a 4-
' byte sequence "00 00 01 00."  Interpreted as a LONG integer (whether or
' not that's how DOS interprets them), these 4 bytes represent 65,536.
' (This program will fail if this memory usage ever changes, for example,
' with other DOS versions.  It works with DOS > 3 and <= 6.22, if not
' others.)  I look for these 4 bytes because immediately following them is
' the fully qualified name of the program currently executing, i.e., THIS
' program.  All I care about is the first character in that name--the disk
' letter.  (This specifies the actual disk that the program resides on.)
' I then use interrupt 21 / function 19 to find out which drive is the
' current one so I can compare it with the other drive letter.)
'
'  Now that I've said all that, I'm not going to do it in the unlikely
' event that your DOS version is less than 3.  Hence, I'm first going
' to define a default output file and then get and test your DOS version.
'
FILE$="MODES.LST"
INREGS.AX=&H3000
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
'
'  Only need major portion of version number.
'
DOSVER=OUTREGS.AX AND &HFF
IF DOSVER>=3 THEN
INREGS.AX=&H6200
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
DEF SEG=OUTREGS.BX
ENVSM=PEEK(&H2C)+256*PEEK(&H2D)
ENVOS=0
DEF SEG=ENVSM
3 DUMMY=PEEK(ENVOS)+256&*(PEEK(ENVOS+1)+256&*(PEEK(ENVOS+2)+256&*PEEK(ENVOS+3)))
IF DUMMY<>65536& THEN ENVOS=ENVOS+1 : GOTO 3
ENVOS=ENVOS+4
DISK=PEEK(ENVOS)
DISK$=UCASE$(CHR$(DISK))
DISK=ASC(DISK$)-65
'
'  Get current drive (AL).
'
INREGS.AX=&H1900
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
AL=OUTREGS.AX AND &HFF
'
'  Finally, finish definition of output file name.
'
IF AL<>DISK THEN FILE$=DISK$+":\"+FILE$
'
'  Okay, that's finally done.  Continue with the point of this program.
' (Redirect Basic back to array A.)
'
DEF SEG=SM
END IF
PRINT "You have a VESA XGA video adapter."
PRINT
'
'  Get/display (if > 1) number of XGA cards.
'
NXGA$=LTRIM$(RTRIM$(STR$(PEEK(OS+14))))
IF VAL(NXGA$)>1 OR VAL(XGA$)>1 THEN
PRINT "  (Your VESA bios reports ";NXGA$;" cards and your XGA bios reports"
PRINT XGA$;" cards.)"
PRINT
END IF
'
'  In VESA-aware systems, byte 4 gives the decimal part of the version
' number and byte 5 gives the mantissa.
'
VESAFRC=PEEK(OS+4)
FIXFRC:
VESAFRC=VESAFRC/10
IF VESAFRC>=1 THEN GOTO FIXFRC
VESA=PEEK(OS+5)+VESAFRC
PRINT "Your VESA version number = ";LTRIM$(STR$(VESA))
PRINT
'
'  Mode support can be confirmed graphically to help correct for the fact
' that VESA boards do not necessarily report information correctly.  (This
' is done by drawing a box around the screen.  If you can't see the box,
' the mode is not supported by your system, regardless of what your video
' card thinks!)
'
LINE INPUT "DO YOU WANT GRAPHICAL MODE CONFIRMATION (Y/N)?";CF$
CF$=UCASE$(CF$)
IF CF$<>"Y" THEN CF$="N"
'
'  If graphical confirmation is being used and there is more than one
' XGA adapter, ask user which one is being used.
'
IF CF$="Y" THEN
ISLOT=1
IF VAL(XGA$)>1 THEN
PRINT
PRINT "Which XGA card ";"(1 - ";XGA$;") is your monitor attached to?"
WRONGSLOT:
INPUT ISLOT
'
'  Make sure valid slot number was input.
'
IF ISLOT<1 OR ISLOT>VAL(XGA$) THEN GOTO WRONGSLOT
END IF
END IF
'
'  Call interrupt 4E / subfunction 01 to store new set of data in array A.
' Bytes 40 to 43 (zero-based) specify a pointer to a list of modes that
' your XGA board thinks it supports.  Point Basic to that list and get
' them.  Each mode is represented by a two-byte integer and the list is
' terminated by -1 (FFFFh).
'
INREGS.AX=&H4E01
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PSM=PEEK(OS+42)+256*PEEK(OS+43) : POFS=PEEK(OS+40)+256*PEEK(OS+41)
DEF SEG=PSM
K=1
5 MD(K)=PEEK(POFS)+256*PEEK(POFS+1) : POFS=POFS+2
IF MD(K)<>-1 AND K<1000 THEN K=K+1 : GOTO 5
'
'  Just in case you actually have more than 1000 video modes, this program
' isn't going to tell about more of them than that.
'
IF K=1000 THEN PRINT : PRINT "List of modes may be incomplete."
NMODES=K : IF MD(K)=-1 THEN NMODES=NMODES-1
'
'  I doubt that this statement will ever activate on a VESA-aware system,
' but I guess it could be conceivable.
'
IF NMODES<1 THEN PRINT "You don't have any VESA video modes." : GOTO 50
'
'  For text mode graphical confirmation, define variable to store
' character "A".
'
DIM CHRA AS INTEGER
CHRA=65
'
'  Save current screen mode (in case it needs to be restored later).
'
INREGS.AX=&H4E04
INREGS.DX=SLOT(ISLOT)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
SAVEMODE=OUTREGS.BX
'
'  Open output file and store header/descriptor information.
'
OPEN FILE$ FOR OUTPUT AS #1
PRINT#1,"Hex BIOS Mode, Mode Type, Resolution, Bit Planes, Pages, Support Type"
PRINT#1," "
'
'  For each supported mode, function 4E / subfunction 02 is used to get
' further information about it.  This information is again stored in the
' array A.  Point Basic back to that array and begin mode analysis.
'
DEF SEG=SM
FOR M=1 TO NMODES
'
'  Mode string is used for output purposes.
'
M$=RTRIM$(LTRIM$(HEX$(MD(M)))) : IF MD(M)<256 THEN M$="0"+M$
IF MD(M)<16 THEN M$="0"+M$
'
'  Set up inputs for subfunction 02.  CX stores the mode being analyzed
' and ES:DI again points to the array A.
'
INREGS.AX=&H4E02
INREGS.CX=MD(M)
INREGS.ES=SM
INREGS.DI=OS
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  The first two bytes in A are only meaningful as a sequence of bits.
' Get this sequence of bits and use the ones relevant to this program.
'
BYTE=CLNG(PEEK(OS)+256*PEEK(OS+1))
'
'  BIN$ returns a 16-character string.
'
B$=BIN$(BYTE)
'
'  Remembering that the significance of bits increases from right to left,
' bit 0 specifies whether or not the mode is supported in hardware and bit
' 2 specifies whether or not it's supported in bios.  (Bit numbers are
' zero-based.)
'
C$=MID$(B$,16,1)
D$=MID$(B$,14,1)
IF C$="1" OR D$="1" THEN
SP$="hardware"
IF C$="0" AND D$="1" THEN SP$="bios"
IF C$="1" AND D$="1" THEN SP$=SP$+"/bios"
'
'  Bit 4 = 0 if MD(M) is a text mode and 1 if MD(M) is a graphics mode.
'
E$=MID$(B$,12,1)
'
'  Get mode characteristics.
'
'  Bytes 4 - 7 give resolution information.
'
HR=PEEK(OS+4)+256*PEEK(OS+5) : VR=PEEK(OS+6)+256*PEEK(OS+7)
'
'  The number of bits per pixel is in byte 11 and the number of bit planes
' per pixel is in byte 10.  The actual number of colors (attributes)
' supported is 2 ^ bits per pixel.
'
COLORS=2!^CSNG(PEEK(OS+11)) : PLANES=PEEK(OS+10)
'
'  Define resolution string.
'
RES$=LTRIM$(RTRIM$(STR$(HR)))+" x "+LTRIM$(RTRIM$(STR$(VR)))+" x "
RES$=RES$+LTRIM$(RTRIM$(STR$(COLORS)))
'
'  Number of supported pages is given by byte 13.
'
PAGES=PEEK(OS+13)
'
'  Mode type as text string is better than mode type as bit integer!
'
IF E$="0" THEN TP$="text"
IF E$="1" THEN TP$="grfx"
'
'  Don't do graphical mode support confirmation if 1) user said not to,
' 2) screen resolution is unavailable, 3) there is no hardware support for
' this mode, or 4) mode is graphic but not supported by bios.  (Can't use
' interrupt calls to draw a box without bios.)
'
IF CF$="N" OR C$="0" OR D$="0" OR HR<=0 OR VR<=0 THEN GOTO 30
'
'  Give user instructions about graphical mode confirmation and then do
' it.  Screen mode is set via function 4E / subfunction 03.  Screen mode
' is stored in BX and video adapter handel goes in DX.  Further, the
' feature connector state (whatever that is) is left unchanged.  Pixels
' are drawn with function 0C.  (0C goes in in AH and pixel color goes in
' AL, e.g., with color 07, AX = 0C07.)  CX stores the x pixel coordinate
' and DX stores y.  BH stores the page number.
'
'  First, put screen in what should be a standard text mode.
'
INREGS.AX=&H4E03
INREGS.BX=3
INREGS.CX=1
INREGS.DX=SLOT(ISLOT)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
PRINT
PRINT "  Momentarily, I am going to attempt to draw a box bounding the edges"
PRINT "of the screen.  (The box will be drawn with pixels for graphics ";
PRINT "modes"
PRINT "and with the character 'A' for text modes.)  If you don't see this box"
PRINT "relatively quickly after pressing a key, press N or ENTER.  If you DO"
PRINT "see the box, press Y."
PRINT
PRINT "Press a key when ready to look for box."
10 IF INKEY$="" THEN GOTO 10
'
'  Now, put screen in mode under test.
'
INREGS.AX=&H4E03
INREGS.BX=MD(M)
INREGS.CX=1
INREGS.DX=SLOT(ISLOT)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  The calls to INTERRUPTX to draw the box are actually normal bios
' functions.  (You don't need a VESA system to use function 0C with
' interrupt 10.  The same comment applies to the functions used to print
' text.  (You do, however, set the screen mode differently in the absence
' of VESA--function 4E (with interrupt 10) is strictly VESA XGA.))
'
'  Set video page for relevant modes.  (A normal bios call can be used for
' this--I'm also not sure how necessary it is.)
'
IF MD(M)<=16 AND (MD(M)<4 OR MD(M)>6) THEN
INREGS.AX=&H500
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
END IF
IF E$="1" THEN
'
'  GRAPHICS MODES
'
FOR I=0 TO HR-1
INREGS.AX=&HC07
INREGS.BX=0
INREGS.CX=I
INREGS.DX=0
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
FOR I=1 TO VR-1
INREGS.AX=&HC07
INREGS.BX=0
INREGS.CX=HR-1
INREGS.DX=I
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
FOR I=0 TO HR-2
INREGS.AX=&HC07
INREGS.BX=0
INREGS.CX=I
INREGS.DX=VR-1
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
FOR I=1 TO VR-2
INREGS.AX=&HC07
INREGS.BX=0
INREGS.CX=0
INREGS.DX=I
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
ELSE
'
'  TEXT MODES
'
FOR I=0 TO HR-1
INREGS.AX=&H1301
INREGS.BX=7
INREGS.CX=1
INREGS.DX=I
INREGS.ES=VARSEG(CHRA)
INREGS.BP=VARPTR(CHRA)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
FOR I=1 TO VR-2
INREGS.AX=&H1301
INREGS.BX=7
INREGS.CX=1
INREGS.DX=HR-1+256*I
INREGS.ES=VARSEG(CHRA)
INREGS.BP=VARPTR(CHRA)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
FOR I=0 TO HR-2
INREGS.AX=&H1301
INREGS.BX=7
INREGS.CX=1
INREGS.DX=I+256*(VR-2)
INREGS.ES=VARSEG(CHRA)
INREGS.BP=VARPTR(CHRA)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
FOR I=1 TO VR-3
INREGS.AX=&H1301
INREGS.BX=7
INREGS.CX=1
INREGS.DX=256*I
INREGS.ES=VARSEG(CHRA)
INREGS.BP=VARPTR(CHRA)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
NEXT I
END IF
'
'  Wait for user to press a key indicating whether or not box was drawn.
'
20 Z$=INKEY$ : IF Z$="" THEN GOTO 20
'
'  If user didn't indicate that box was visible (and drawn correctly)
' don't list mode in output file.
'
IF UCASE$(Z$)<>"Y" THEN GOTO 40
30 IF E$="0" THEN PRINT#1,M$;"    ";TP$,RES$,,PLANES,PAGES;"     ";SP$
IF E$="1" THEN PRINT#1,M$;"    ";TP$,RES$,PLANES,PAGES;"     ";SP$
PRINT#1," "
40 END IF
NEXT M
CLOSE #1
'
'  If graphical mode testing was being used, put screen back in original
' state.
'
IF CF$="Y" THEN
INREGS.AX=&H4E03
INREGS.BX=SAVEMODE
INREGS.CX=1
INREGS.DX=SLOT(ISLOT)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
END IF
PRINT
PRINT "Look in ";FILE$;" for list of supported video modes."
ELSE
PRINT "You don't have a VESA XGA card."
END IF
ELSE
PRINT
PRINT "You don't have any type of XGA support."
END IF
50 END
'
'  This is a "functionized" version of code extracted from a more general
' numeric base conversion program by Robert B. Relf, (C) 1984.  This just
' uses the part of Mr. Relf's code that converts decimal to binary.
'
FUNCTION BIN$(NUM AS LONG)
DIM X AS INTEGER
IF NUM<0 THEN NUM=NUM+65536&
BIN1$=""
FOR X=15 TO 0 STEP -1
IF NUM>=(2^X) THEN
BIN1$=BIN1$+"1"
NUM=NUM-(2^X)
ELSE
BIN1$=BIN1$+"0"
END IF
NEXT X
BIN1$=LEFT$(BIN1$,8)+RIGHT$(BIN1$,8)
BIN$=BIN1$
END FUNCTION
